script_name('ImGui Scoreboard')
script_description('ImGui SA:MP Scoreboard')
script_dependencies('SAMPFUNCS', 'SAMP', 'ImGui')
script_moonloader(025)

require 'moonloader'
local imgui = require 'imgui'
local vkeys = require 'vkeys'
local bitex = require 'bitex'
local memory = require 'memory'
local encoding = require 'encoding'
local inicfg = require 'inicfg'
u8 = encoding.UTF8
encoding.default = 'CP1251'

-- DISABLE DEFAULT SA:MP SCOREBOARD (MINIFIED)
(function()
	patches={['SAMP_PATCH_SCOREBOARDTOGGLEON']={old_value=nil,offset=0x6AA10,value=0xC3,size=1},['SAMP_PATCH_SCOREBOARDTOGGLEONKEYLOCK']={old_value=nil,offset=0x6AD30,value=0xC3,size=1}}setmetatable(patches,{__call=function(a,b,c)if type(b)~='string'then return end;local d=a[b]if d~=nil then if type(c)~='boolean'then c=false end;local e=false;if c==false and d.old_value==nil then d.old_value=memory.getint8(sampGetBase()+d.offset,true)memory.write(sampGetBase()+d.offset,d.value,d.size,true)e=true elseif d.old_value~=nil then memory.write(sampGetBase()+d.offset,d.old_value,d.size,true)d.old_value=nil end;return e end end})
end)()
local themsDir = getWorkingDirectory() .. "\\resource\\scoreboard"
local allset = inicfg.load({
	set = {
		curTheme = "main",
		type = 1
	}
}, "scoreboard")
local cfg = nil
local copColor = {
	[12] = {11},
	[6] = {29}
}
local setTable = {
	["  / "] = {
		[8] = " ",
		[9] = " ",
		[10] = " "
	},
	[""] = {
		[26] = " ",
		[27] = " ",
		[28] = " "
	},
	[""] = {
		[12] = "",
		[3] = " ",
		[6] = "",
		[1] = ""
	},
	[""] = {
		[23] = " ",
		[24] = " ",
		[25] = " "
	}
}
local style = imgui.GetStyle()
local colors = style.Colors
local clr = imgui.Col
local ImVec4 = imgui.ImVec4
local background = nil
local bgImage = imgui.ImBool(false)

function loadTheme(name)
	cfg = inicfg.load({
		colors = {
			[1] = imgui.ImColor(240, 240, 240, 240):GetU32(),
			[3] = imgui.ImColor(3, 3, 0, 230):GetU32(),
			[8] = imgui.ImColor(210, 210, 0, 100):GetU32(),
			[6] = imgui.ImColor(110, 110, 127, 127):GetU32(),
			[9] = imgui.ImColor(210, 210, 0, 140):GetU32(),
			[10] = imgui.ImColor(210, 210, 0, 70):GetU32(),
			[12] = imgui.ImColor(120, 120, 0, 232):GetU32(),
			[23] = imgui.ImColor(180, 180, 0, 163):GetU32(),
			[24] = imgui.ImColor(180, 180, 0, 100):GetU32(),
			[25] = imgui.ImColor(180, 180, 0, 100):GetU32(),
			[26] = imgui.ImColor(160, 160, 160, 60):GetU32(),
			[27] = imgui.ImColor(160, 160, 160, 60):GetU32(),
			[28] = imgui.ImColor(160, 160, 160, 30):GetU32()
		},
		set = {
			bgimg = false,
			imageColor = imgui.ImColor(255, 255, 255, 255):GetU32()
		}
	}, name and (themsDir .. "\\" .. name .. "\\data.ini") or ("moonloader\\resource\\scoreboard\\main\\data.ini"))
	bgImage.v = cfg.set.bgimg
	for k, v in pairs(cfg.colors) do
		colors[k] = imgui.ImColor(v):GetVec4()
	end
	for k, v in pairs(copColor) do
		for _, iv in ipairs(copColor[k]) do
			colors[iv] = colors[k]
		end
	end
	if doesFileExist(name and (themsDir .. "\\" .. name .. "\\scoreboard.png") or ("moonloader\\resource\\scoreboard\\main\\scoreboard.png")) then
		background = imgui.CreateTextureFromFile(name and (themsDir .. "\\" .. name .. "\\scoreboard.png") or ("moonloader\\resource\\scoreboard\\main\\scoreboard.png"))
	else
		background = nil
	end
end

local ToScreen = convertGameScreenCoordsToWindowScreenCoords
local show_main_window = imgui.ImBool(false)
local show_set_window = imgui.ImBool(false)
local searchBuf = imgui.ImBuffer(256)
local createThemBuf = imgui.ImBuffer(32)
local playerCount = 0
local cStyle = imgui.ImInt(0)
local cType = imgui.ImInt(allset.set.type)
local thems = {}
local themsId = {}
local notThems = false
local focusId = -1
local scrollToId = false
loadTheme(allset.set.curTheme)
bgImage.v = cfg.set.bgimg
if not doesDirectoryExist("moonloader\\resource") then
	createDirectory("moonloader\\resource")
end
if not doesDirectoryExist("moonloader\\resource\\scoreboard") then
	createDirectory("moonloader\\resource\\scoreboard")
end
function apply_custom_style()
	imgui.SwitchContext()

	style.WindowRounding = 1.5
	style.WindowTitleAlign = imgui.ImVec2(0.5, 0.5)
	style.ChildWindowRounding = 1.5
	style.FrameRounding = 1.0
	style.ItemSpacing = imgui.ImVec2(5.0, 4.0)
	style.ScrollbarSize = 13.0
	style.ScrollbarRounding = 0
	style.GrabMinSize = 8.0
	style.GrabRounding = 1.0
	-- style.Alpha =
	style.WindowPadding = imgui.ImVec2(0.0, 0.0)
	-- style.WindowMinSize =
	style.FramePadding = imgui.ImVec2(2.5, 3.5)
	-- style.ItemInnerSpacing =
	-- style.TouchExtraPadding =
	-- style.IndentSpacing =
	-- style.ColumnsMinSpacing = ?
	style.ButtonTextAlign = imgui.ImVec2(0.5, 0.5)
	-- style.DisplayWindowPadding =
	-- style.DisplaySafeAreaPadding =
	-- style.AntiAliasedLines =
	-- style.AntiAliasedShapes =
	-- style.CurveTessellationTol =
	colors[clr.TextDisabled]           = ImVec4(0.50, 0.50, 0.50, 1.00)
	colors[clr.ChildWindowBg]          = ImVec4(1.00, 1.00, 1.00, 0.00)
	colors[clr.PopupBg]                = ImVec4(0.04, 0.04, 0.04, 0.9)
	colors[clr.ComboBg]                = colors[clr.PopupBg]
	-- colors[clr.Border]                 = ImVec4(0.43, 0.43, 0.50, 0.50)
	colors[clr.BorderShadow]           = ImVec4(0.00, 0.00, 0.00, 0.00)
	colors[clr.TitleBgCollapsed]       = ImVec4(0.05, 0.05, 0.05, 0.79)
	colors[clr.MenuBarBg]              = ImVec4(0.14, 0.14, 0.14, 1.00)
	colors[clr.ScrollbarBg]            = ImVec4(0.02, 0.02, 0.02, 0.53)
	colors[clr.ScrollbarGrab]          = ImVec4(0.31, 0.31, 0.31, 1.00)
	colors[clr.ScrollbarGrabHovered]   = ImVec4(0.41, 0.41, 0.41, 1.00)
	colors[clr.ScrollbarGrabActive]    = ImVec4(0.51, 0.51, 0.51, 1.00)
	colors[clr.CheckMark]              = ImVec4(1.00, 1.00, 1.00, 1.00)
	colors[clr.SliderGrab]             = ImVec4(0.28, 0.28, 0.28, 1.00)
	colors[clr.SliderGrabActive]       = ImVec4(0.35, 0.35, 0.35, 1.00)
	-- colors[clr.Header]                 = ImVec4(0.12, 0.12, 0.12, 0.94)
	-- colors[clr.HeaderHovered]          = ImVec4(0.25, 0.25, 0.25, 0.2)
	-- colors[clr.HeaderActive]           = ImVec4(0.16, 0.16, 0.16, 0.90)
	-- colors[clr.Separator]              = colors[clr.Border]
	colors[clr.SeparatorHovered]       = ImVec4(0.26, 0.59, 0.98, 0.78)
	colors[clr.SeparatorActive]        = ImVec4(0.26, 0.59, 0.98, 1.00)
	colors[clr.ResizeGrip]             = ImVec4(0.26, 0.59, 0.98, 0.25)
	colors[clr.ResizeGripHovered]      = ImVec4(0.26, 0.59, 0.98, 0.67)
	colors[clr.ResizeGripActive]       = ImVec4(0.26, 0.59, 0.98, 0.95)
	colors[clr.CloseButton]            = ImVec4(0.41, 0.41, 0.41, 0.50)
	colors[clr.CloseButtonHovered]     = ImVec4(0.98, 0.39, 0.36, 1.00)
	colors[clr.CloseButtonActive]      = ImVec4(0.98, 0.39, 0.36, 1.00)
	colors[clr.PlotLines]              = ImVec4(0.61, 0.61, 0.61, 1.00)
	colors[clr.PlotLinesHovered]       = ImVec4(1.00, 0.43, 0.35, 1.00)
	colors[clr.PlotHistogram]          = ImVec4(0.90, 0.70, 0.00, 1.00)
	colors[clr.PlotHistogramHovered]   = ImVec4(1.00, 0.60, 0.00, 1.00)
	colors[clr.TextSelectedBg]         = ImVec4(0.26, 0.59, 0.98, 0.35)
	colors[clr.ModalWindowDarkening]   = ImVec4(0.10, 0.10, 0.10, 0.35)
	-- colors[clr.WindowBg]               = imgui.ImColor(3, 3, 0, 230):GetVec4()
	-- colors[clr.FrameBg]    	 		  = imgui.ImColor(210, 210, 0, 100):GetVec4()
	-- colors[clr.FrameBgHovered]         = imgui.ImColor(210, 210, 0, 140):GetVec4()
	-- colors[clr.FrameBgActive]          = imgui.ImColor(210, 210, 0, 70):GetVec4()
	-- colors[clr.TitleBg]                = imgui.ImColor(120, 120, 0, 232):GetVec4()
	-- colors[clr.TitleBgActive]          = imgui.ImColor(120, 120, 0, 232):GetVec4()
	-- colors[clr.Button]                 = imgui.ImColor(180, 180, 0, 163):GetVec4()
	-- colors[clr.ButtonHovered]          = imgui.ImColor(180, 180, 0, 100):GetVec4()
	-- colors[clr.ButtonActive]           = imgui.ImColor(100, 100, 0, 100):GetVec4()
end

apply_custom_style()
function main()
	if not isSampfuncsLoaded() or not isSampLoaded() then return end
	while not isSampAvailable() do wait(0) end

	patches('SAMP_PATCH_SCOREBOARDTOGGLEON')
	patches('SAMP_PATCH_SCOREBOARDTOGGLEONKEYLOCK')


	local h, n = findFirstFile('moonloader\\resource\\scoreboard\\*')
	local i = 1
	while true do
		wait(0)
		if h then
			if n then
				local f = io.open(n)
				if not f and n ~= "." and n ~= ".." then
					table.insert(thems, n)
					themsId[tostring(n)] = i
					if allset.set.curTheme == n then
						cStyle.v = i - 1
					end
					i = i + 1
				end
				n = findNextFile(h)
			else
				findClose(h)
				if #thems == 0 then
					thems[1] = "main"
					themsId["main"] = 1
					notThems = true
					loadTheme()
				end
			end
		end
		imgui.Process = show_main_window.v
	end
end

function toggleScoreboard(flag)
	if type(flag) == 'boolean' then
		show_main_window.v = flag
	else
		show_main_window.v = not show_main_window.v
	end
	if show_main_window.v and focusId > -1 then
		scrollToId = true
	end
end

function getLocalPlayerId()
	local _, id = sampGetPlayerIdByCharHandle(playerPed)
	return id
end

function onWindowMessage(msg, wparam, lparam)
	if(msg == 0x100 or msg == 0x101) then
		if(wparam == VK_ESCAPE and show_main_window.v) and not isPauseMenuActive() then
			consumeWindowMessage(true, false)
			if(msg == 0x101)then
				toggleScoreboard(false)
			end
		elseif wparam == VK_TAB and not isKeyDown(VK_TAB) and not isPauseMenuActive() then
			if not show_main_window.v then
				if not sampIsChatInputActive() then
					toggleScoreboard(true)
				end
			else
				toggleScoreboard(false)
			end
			consumeWindowMessage(true, false)
		end
	end
end


local glyph_ranges = nil
function imgui.BeforeDrawFrame()
    if not fontChanged then
        fontChanged = true
        glyph_ranges = imgui.GetIO().Fonts:GetGlyphRangesCyrillic()
        imgui.GetIO().Fonts:Clear()
        imgui.GetIO().Fonts:AddFontFromFileTTF(getFolderPath(0x14) .. '\\arialbd.ttf', 14.0, nil, glyph_ranges)
    end
end
function imgui.OnDrawFrame()
	if show_main_window.v then
		if show_set_window.v then
			local x, y = ToScreen(510, 30)
			local w, h = ToScreen(638, 175)
			imgui.PushStyleVar(imgui.StyleVar.WindowPadding, imgui.ImVec2(4.0, 4.0))
			imgui.SetNextWindowPos(imgui.ImVec2(w-220, y), imgui.Cond.FirstUseEver, imgui.ImVec2(0.0, 0.0))
			imgui.SetNextWindowSize(imgui.ImVec2(220, 609), imgui.Cond.FirstUseEver)
			imgui.Begin(u8'', show_set_window, imgui.WindowFlags.NoCollapse + imgui.WindowFlags.NoResize)
			imgui.SetWindowSize(imgui.ImVec2(220, 609))
			imgui.Text(u8" :")
			imgui.PushItemWidth(212)
			if imgui.Combo("##type", cType, {u8"", u8"", u8"", u8"  "}) and #thems > 0 then
				allset.set.type = cType.v
			end
			imgui.Separator()
			imgui.Text(u8":")
			local rThems = {}
			for k, v in ipairs(thems) do
				rThems[k] = u8(v)
			end
			imgui.PushItemWidth(151)
			if imgui.Combo("##thems", cStyle, rThems) and #thems > 0 then
				if notThems then
					inicfg.save(cfg, "..\\resource\\scoreboard\\main\\data.ini")
					notThems = false
				else
					inicfg.save(cfg, "..\\resource\\scoreboard\\" .. allset.set.curTheme .. "\\data.ini")
				end
				allset.set.curTheme = thems[cStyle.v + 1]
				inicfg.save(allset, "scoreboard")
				loadTheme(allset.set.curTheme)
			end
			imgui.PopItemWidth()
			imgui.SameLine()
			if imgui.Button(u8"") then
				imgui.OpenPopup(u8" ")
			end
			if imgui.BeginPopupModal(u8" ", _, imgui.WindowFlags.NoCollapse + imgui.WindowFlags.NoResize + imgui.WindowFlags.NoMove) then
				imgui.Text(u8" :")
				imgui.InputText("##createThemBuf", createThemBuf, imgui.InputTextFlags.CharsNoBlank)
				if imgui.Button(u8"", imgui.ImVec2(100, 0)) then
					imgui.CloseCurrentPopup()
					if createThemBuf.v:len() > 0 and themsId[tostring(u8:decode(createThemBuf.v))] == nil then
						createDirectory(themsDir .. "\\" .. u8:decode(createThemBuf.v))
						themsId[tostring(u8:decode(createThemBuf.v))] = #themsId
						thems[#thems+1] = u8:decode(createThemBuf.v)
					end
				end
				imgui.SameLine()
				if imgui.Button(u8"", imgui.ImVec2(100, 0)) then
					imgui.CloseCurrentPopup()
				end
				imgui.EndPopup()
			end
			imgui.Separator()
			if imgui.Checkbox(u8" ", bgImage) then
				cfg.set.bgimg = bgImage.v
			end
			local color = imgui.ImColor(cfg.set.imageColor)
			imgui.AlignTextToFramePadding()
			if bgImage.v then imgui.Text(u8("")) else imgui.TextDisabled(u8"") end
			imgui.SameLine(195)
			if imgui.ColorEdit4("##imageColor", color.v, imgui.ColorEditFlags.NoInputs + imgui.ColorEditFlags.NoLabel + imgui.ColorEditFlags.AlphaBar) then
				cfg.set.imageColor = color:GetU32()
			end
			for k, v in pairs(setTable) do
				imgui.Separator()
				imgui.Text(u8(k) .. ":")
				for sk, sv in pairs(v) do
					local color = imgui.ImColor(cfg.colors[sk])
					imgui.AlignTextToFramePadding()
					imgui.Text(u8(sv))
					imgui.SameLine(195)
					if imgui.ColorEdit4("##" .. sk, color.v, imgui.ColorEditFlags.NoInputs + imgui.ColorEditFlags.NoLabel + imgui.ColorEditFlags.AlphaBar) then
						cfg.colors[sk] = color:GetU32()
						colors[sk] = color:GetVec4()
						if copColor[sk] then
							for _, iv in ipairs(copColor[sk]) do
								colors[iv] = color:GetVec4()
							end
						end
					end
				end
			end
			imgui.Separator()
			if imgui.Button(u8" ", imgui.ImVec2(212, 0)) then
				if notThems then
					inicfg.save(cfg, "..\\resource\\scoreboard\\main\\data.ini")
					notThems = false
				else
					inicfg.save(cfg, "..\\resource\\scoreboard\\" .. allset.set.curTheme .. "\\data.ini")
				end
				inicfg.save(allset, "scoreboard")
			end
			imgui.End()
			imgui.PopStyleVar()
		end
		playerCount = 0
		if allset.set.type == 0 then
			x, y = ToScreen(160, 90)
			w, h = ToScreen(480, 358)
		elseif allset.set.type == 1 then
			x, y = ToScreen(130, 60)
			w, h = ToScreen(510, 388)
		elseif allset.set.type == 2 then
			x, y = ToScreen(90, 30)
			w, h = ToScreen(550, 418)
		elseif allset.set.type == 3 then
			x, y = ToScreen(0, 0)
			w, h = ToScreen(640, 448)
		end
		imgui.SetNextWindowPos(imgui.ImVec2(x, y), imgui.Cond.FirstUseEver, imgui.ImVec2(0.0, 0.0))
		imgui.SetNextWindowSize(imgui.ImVec2(w-x , h-y), imgui.Cond.FirstUseEver)
		--
		imgui.Begin(encoding.UTF8(sampGetCurrentServerName()), show_main_window, imgui.WindowFlags.NoCollapse + imgui.WindowFlags.NoResize + imgui.WindowFlags.NoMove + imgui.WindowFlags.AlwaysUseWindowPadding)

		imgui.SetWindowPos(imgui.ImVec2(x, y))
		imgui.SetWindowSize(imgui.ImVec2(w-x, h-y))

		if background and bgImage.v then
			local size = imgui.GetWindowSize()
			local bColor = cfg.set.imageColor
			imgui.Image(background, imgui.ImVec2(size.x , size.y-21), imgui.ImVec2(0, 0), imgui.ImVec2(1, 1), imgui.ImColor(bColor):GetVec4())
		end
		imgui.SetCursorPos(imgui.ImVec2(4, 24))
		imgui.AlignTextToFramePadding()
		imgui.Text(u8(' : ' .. sampGetPlayerCount(false)))
		imgui.SameLine(w-x-232)
		if imgui.Button(u8"") then
			show_set_window.v = not show_set_window.v
		end
		imgui.SameLine()
		imgui.PushItemWidth(150)
		imgui.PushAllowKeyboardFocus(false)
		imgui.InputText("##search", searchBuf, imgui.InputTextFlags.EnterReturnsTrue + imgui.InputTextFlags.CharsNoBlank)
		imgui.PopAllowKeyboardFocus()
		imgui.PopItemWidth()
		if not imgui.IsItemActive() and #searchBuf.v == 0 then
			local r, g, b, a = imgui.ImColor(colors[1]):GetRGBA()
			imgui.SameLine(w-x-153)
			imgui.PushStyleColor(imgui.Col.Text, imgui.ImColor(r, g, b, 180):GetVec4())
			imgui.Text(u8"   / id")
			imgui.PopStyleColor()
		end
		imgui.Columns(4)
		imgui.Separator()
		imgui.NewLine()
		imgui.SameLine(2)
		imgui.SetColumnWidth(-1, 32); imgui.Text('ID'); imgui.NextColumn()
		imgui.SetColumnWidth(-1, w-x-200); imgui.Text(u8''); imgui.NextColumn()
		imgui.SetColumnWidth(-1, 90); imgui.Text(u8''); imgui.NextColumn()
		imgui.SetColumnWidth(-1, 50); imgui.Text(u8''); imgui.NextColumn()
		imgui.Columns(1)
		imgui.Separator()
		imgui.BeginChild("##scroll", imgui.ImVec2(0, 0), false)
		imgui.Columns(4)
		imgui.SetColumnWidth(-1, 32);imgui.NextColumn()
		imgui.SetColumnWidth(-1, w-x-200); imgui.NextColumn()
		imgui.SetColumnWidth(-1, 90);imgui.NextColumn()
		imgui.SetColumnWidth(-1, 50); imgui.NextColumn()
		local local_player_id = getLocalPlayerId()
		if(#searchBuf.v < 1) then
			drawScoreboardPlayer(local_player_id)
		else
			if(string.find(sampGetPlayerNickname(local_player_id):lower(), searchBuf.v:lower(), 1, true) or local_player_id == tonumber(searchBuf.v))then
				drawScoreboardPlayer(local_player_id)
			end
		end
		for i = 0, sampGetMaxPlayerId(false) do
			if local_player_id ~= i and sampIsPlayerConnected(i) then
				if(#searchBuf.v > 0) then
					if(string.find(sampGetPlayerNickname(i):lower(), searchBuf.v:lower(), 1, true) or i == tonumber(searchBuf.v))then
						drawScoreboardPlayer(i)
					end
				else
					drawScoreboardPlayer(i)
				end
			end
		end

		imgui.Columns(1)
		if(playerCount == 0)then
			imgui.SameLine(5.0); imgui.Text(u8"  ...")
		end
		imgui.Separator()
		imgui.EndChild()

		imgui.End()
	end
end
function getDistanceToPlayer(playerId)
	if sampIsPlayerConnected(playerId) then
		local result, ped = sampGetCharHandleBySampPlayerId(playerId)
		if result and doesCharExist(ped) then
			local myX, myY, myZ = getCharCoordinates(playerPed)
			local playerX, playerY, playerZ = getCharCoordinates(ped)
			return getDistanceBetweenCoords3d(myX, myY, myZ, playerX, playerY, playerZ)
		end
	end
	return nil
end

function drawScoreboardPlayer(id)
	-- send scores&ping update?
	local distance
	local isPlayerInStream = sampGetCharHandleBySampPlayerId(id)
	local nickname = encoding.UTF8(sampGetPlayerNickname(id))
	local score = sampGetPlayerScore(id)
	local ping = sampGetPlayerPing(id)
	local color = sampGetPlayerColor(id)
	local r, g, b = bitex.bextract(color, 16, 8), bitex.bextract(color, 8, 8), bitex.bextract(color, 0, 8)
	local imgui_RGBA = imgui.ImVec4(r / 255.0, g / 255.0, b / 255.0, 1)

	playerCount = playerCount + 1
	imgui.NewLine()
	imgui.SameLine(2)
	if imgui.Selectable(id, id == focusId, imgui.SelectableFlags.SpanAllColumns + imgui.SelectableFlags.AllowDoubleClick) then
		if imgui.IsMouseDoubleClicked(0) then
			sampSendClickPlayer(id, 0)
			lua_thread.create(function ()
				wait(150)
				toggleScoreboard(false)
			end)
		else
			focusId = focusId == id and -1 or id
		end
	end

	imgui.PushStyleVar(imgui.StyleVar.WindowPadding, imgui.ImVec2(4.0, 3.0))
	if imgui.BeginPopupContextItem() then
		imgui.TextColored(imgui_RGBA, nickname .. "[" .. id .. "]")
		local btnSize = imgui.ImVec2(0.0, 0.0)
		imgui.Separator()
		if(id ~= getLocalPlayerId())then
			if imgui.Button(u8' ', btnSize) then
				imgui.CloseCurrentPopup()
				toggleScoreboard(false)
				sampSetChatInputText("/pm " .. id .. " ")
				sampSetChatInputEnabled(true)
			end
		end
		if imgui.Button(u8' ', btnSize) then
			setClipboardText(nickname)
			imgui.CloseCurrentPopup()
		end
		imgui.EndPopup()
	end
	imgui.PopStyleVar()

	imgui.NextColumn()

	imgui.TextColored(imgui_RGBA, nickname); imgui.NextColumn()
	imgui.Text(score); imgui.NextColumn()
	imgui.Text(ping); imgui.NextColumn()

	if scrollToId and focusId > -1 and focusId == id then
		scrollToId = false
		imgui.SetScrollHere(0.43)
	end
end

function testCallBack(data)
	sampAddChatMessage("1", -1)
end

function onScriptTerminate(script, quitGame)
	if script == thisScript() then
		if not doesDirectoryExist("moonloader\\config") then
			createDirectory("moonloader\\config")
		end
		if notThems then
			inicfg.save(cfg, "..\\resource\\scoreboard\\main\\data.ini")
			notThems = false
		else
			inicfg.save(cfg, "..\\resource\\scoreboard\\" .. allset.set.curTheme .. "\\data.ini")
		end
		inicfg.save(allset, "scoreboard")
		patches('SAMP_PATCH_SCOREBOARDTOGGLEON', true)
		patches('SAMP_PATCH_SCOREBOARDTOGGLEONKEYLOCK', true)
		showCursor(false)
	end
end
