-- Pizda
script_name('N0ps')
script_author('Rjx13')

-- Includes
local imgui = require 'imgui'
local Packets = require 'raknet.structs_packet'
local RPC = require 'raknet.structs_rpc'

-- Vars
local main_window_state = imgui.ImBool(false)
local currentDrawingMenu = 1
local currentPage = 'Incoming RPC'

-- Thank you, Musaigen (Copyed from script "RakLogger++" - https://blast.hk/threads/36665/)
local filter_in_filter = imgui.ImBuffer(256) -- . ?
local filter_packets_incoming = {}
local filter_packets_outcoming = {}
local filter_rpc_incoming = {}
local filter_rpc_outcoming = {}

function check_has_in_filter(name, t)
    for key, value in pairs(t) do
        if value[1]:gsub('##.+', '') == name then return value[2].v end
    end
end

function render_filter(num, t, f) -- f = 
  if currentDrawingMenu == num  then
    for key, value in pairs(t) do
        if #f.v > 0 then
            if string.find(string.lower(value[1]), string.lower(f.v), 1, true) then
                imgui.Checkbox(value[1], value[2])
            end
        else
            imgui.Checkbox(value[1], value[2])
        end
    end
  end
end

for i = 200, 212 do
    if raknetGetPacketName(i) ~= nil then
        if Packets[i] ~= nil then
            filter_packets_incoming[i] = {raknetGetPacketName(i), imgui.ImBool(false)}
            filter_packets_outcoming[i] = {raknetGetPacketName(i) ..'##1', imgui.ImBool(false)}
        end
    end
end
for i = 1, 166 do
    if raknetGetRpcName(i) ~= nil then
        if RPC.incoming[i] ~= nil then
            filter_rpc_incoming[i] = {raknetGetRpcName(i), imgui.ImBool(false)}
        end
        if RPC.outcoming[i] ~= nil then
            filter_rpc_outcoming[i] = {raknetGetRpcName(i) .. '##1', imgui.ImBool(false)}
        end
    end
end

-- ImGui
function imgui.OnDrawFrame()
  if main_window_state.v then
    imgui.SetNextWindowSize(imgui.ImVec2(545, 415), imgui.Cond.FirstUseEver)
    local sW, sH = getScreenResolution()
    imgui.SetNextWindowPos(imgui.ImVec2(sW / 2, sH / 2), imgui.Cond.ImGuiCond_Always, imgui.ImVec2(0.5, 0.5))

    imgui.Begin('N0ps - ' .. currentPage, main_window_state, imgui.WindowFlags.NoResize or imgui.WindowFlags.NoCollapse or imgui.WindowFlags.NoSavedSettings)

		if imgui.Button("Incoming RPC", imgui.ImVec2(126, 25)) then currentDrawingMenu = 1 currentPage = 'Incoming RPC' end
		imgui.SameLine()
		if imgui.Button("Outcoming RPC", imgui.ImVec2(126, 25)) then currentDrawingMenu = 2 currentPage = 'Outcoming RPC' end
		imgui.SameLine()
		if imgui.Button("Incoming Packets", imgui.ImVec2(126, 25)) then currentDrawingMenu = 3 currentPage = 'Incoming Packets' end
		imgui.SameLine()
		if imgui.Button("Outcoming Packets", imgui.ImVec2(126, 25)) then currentDrawingMenu = 4 currentPage = 'Outcoming Packets' end

    imgui.BeginChild('control-buttons', imgui.ImVec2(518, 344), true)
    render_filter(1, filter_rpc_incoming, filter_in_filter)
    render_filter(2, filter_rpc_outcoming, filter_in_filter)
    render_filter(3, filter_packets_incoming, filter_in_filter)
    render_filter(4, filter_packets_outcoming, filter_in_filter)
    imgui.EndChild()

    imgui.End()
  end
end

-- EntryPoint
function main()
	repeat wait(0) until isSampAvailable()

	glyph_ranges = imgui.GetIO().Fonts:GetGlyphRangesCyrillic();
	font = imgui.GetIO().Fonts:AddFontFromFileTTF(getFolderPath(0x14) .. '\\arialbd.ttf', 14.0, nil, glyph_ranges);
	apply_custom_style()
	imgui.Process = true

	sampRegisterChatCommand("nops", function()
		main_window_state.v = not main_window_state.v
	end)

	lua_thread.create(function ()
		while true do
  		wait(0)
  		imgui.Process = main_window_state.v
		end
	end)

	wait(-1)
end

-- RPC
function onReceiveRpc(id, bs)
  if RPC.incoming[id] and check_has_in_filter(raknetGetRpcName(id), filter_rpc_incoming) then return false end
end

function onSendRpc(id, bs, priority, reliability, orderingChannel)
  if RPC.outcoming[id] and check_has_in_filter(raknetGetRpcName(id), filter_rpc_outcoming) then return false end
end

-- Packets
function onReceivePacket(id, bs)
  if check_has_in_filter(raknetGetPacketName(id), filter_packets_incoming) then return false end
end

function onSendPacket(id, bs, priority, reliability, orderingChannel)
  if check_has_in_filter(raknetGetPacketName(id), filter_packets_outcoming) then return false end
end

function apply_custom_style()
  imgui.SwitchContext()
  local style = imgui.GetStyle()
  local colors = style.Colors
  local clr = imgui.Col
  local ImVec4 = imgui.ImVec4

  style.WindowRounding = 2.0
  style.WindowTitleAlign = imgui.ImVec2(0.5, 0.84)
  style.ChildWindowRounding = 2.0
  style.FrameRounding = 2.0
  style.ItemSpacing = imgui.ImVec2(5.0, 4.0)
  style.ScrollbarSize = 13.0
  style.ScrollbarRounding = 0
  style.GrabMinSize = 8.0
  style.GrabRounding = 1.0

  colors[clr.FrameBg]                = ImVec4(0.16, 0.29, 0.48, 0.54)
  colors[clr.FrameBgHovered]         = ImVec4(0.26, 0.59, 0.98, 0.40)
  colors[clr.FrameBgActive]          = ImVec4(0.26, 0.59, 0.98, 0.67)
  colors[clr.TitleBg]                = ImVec4(0.04, 0.04, 0.04, 1.00)
  colors[clr.TitleBgActive]          = ImVec4(0.16, 0.29, 0.48, 1.00)
  colors[clr.TitleBgCollapsed]       = ImVec4(0.00, 0.00, 0.00, 0.51)
  colors[clr.CheckMark]              = ImVec4(0.26, 0.59, 0.98, 1.00)
  colors[clr.SliderGrab]             = ImVec4(0.24, 0.52, 0.88, 1.00)
  colors[clr.SliderGrabActive]       = ImVec4(0.26, 0.59, 0.98, 1.00)
  colors[clr.Button]                 = ImVec4(0.26, 0.59, 0.98, 0.40)
  colors[clr.ButtonHovered]          = ImVec4(0.26, 0.59, 0.98, 1.00)
  colors[clr.ButtonActive]           = ImVec4(0.06, 0.53, 0.98, 1.00)
  colors[clr.Header]                 = ImVec4(0.26, 0.59, 0.98, 0.31)
  colors[clr.HeaderHovered]          = ImVec4(0.26, 0.59, 0.98, 0.80)
  colors[clr.HeaderActive]           = ImVec4(0.26, 0.59, 0.98, 1.00)
  colors[clr.Separator]              = colors[clr.Border]
  colors[clr.SeparatorHovered]       = ImVec4(0.26, 0.59, 0.98, 0.78)
  colors[clr.SeparatorActive]        = ImVec4(0.26, 0.59, 0.98, 1.00)
  colors[clr.ResizeGrip]             = ImVec4(0.26, 0.59, 0.98, 0.25)
  colors[clr.ResizeGripHovered]      = ImVec4(0.26, 0.59, 0.98, 0.67)
  colors[clr.ResizeGripActive]       = ImVec4(0.26, 0.59, 0.98, 0.95)
  colors[clr.TextSelectedBg]         = ImVec4(0.26, 0.59, 0.98, 0.35)
  colors[clr.Text]                   = ImVec4(1.00, 1.00, 1.00, 1.00)
  colors[clr.TextDisabled]           = ImVec4(0.50, 0.50, 0.50, 1.00)
  colors[clr.WindowBg]               = ImVec4(0.06, 0.06, 0.06, 0.94)
  colors[clr.ChildWindowBg]          = ImVec4(1.00, 1.00, 1.00, 0.00)
  colors[clr.PopupBg]                = ImVec4(0.08, 0.08, 0.08, 0.94)
  colors[clr.ComboBg]                = colors[clr.PopupBg]
  colors[clr.Border]                 = ImVec4(0.43, 0.43, 0.50, 0.50)
  colors[clr.BorderShadow]           = ImVec4(0.00, 0.00, 0.00, 0.00)
  colors[clr.MenuBarBg]              = ImVec4(0.14, 0.14, 0.14, 1.00)
  colors[clr.ScrollbarBg]            = ImVec4(0.02, 0.02, 0.02, 0.53)
  colors[clr.ScrollbarGrab]          = ImVec4(0.31, 0.31, 0.31, 1.00)
  colors[clr.ScrollbarGrabHovered]   = ImVec4(0.41, 0.41, 0.41, 1.00)
  colors[clr.ScrollbarGrabActive]    = ImVec4(0.51, 0.51, 0.51, 1.00)
  colors[clr.CloseButton]            = ImVec4(0.41, 0.41, 0.41, 0.50)
  colors[clr.CloseButtonHovered]     = ImVec4(0.98, 0.39, 0.36, 1.00)
  colors[clr.CloseButtonActive]      = ImVec4(0.98, 0.39, 0.36, 1.00)
  colors[clr.PlotLines]              = ImVec4(0.61, 0.61, 0.61, 1.00)
  colors[clr.PlotLinesHovered]       = ImVec4(1.00, 0.43, 0.35, 1.00)
  colors[clr.PlotHistogram]          = ImVec4(0.90, 0.70, 0.00, 1.00)
  colors[clr.PlotHistogramHovered]   = ImVec4(1.00, 0.60, 0.00, 1.00)
  colors[clr.ModalWindowDarkening]   = ImVec4(0.80, 0.80, 0.80, 0.35)
end
