local memory = require 'memory'
local sampev = require 'samp.events'
local ffi = require 'ffi'
local imgui = require 'imgui'
local sW, sH = getScreenResolution()
local inicfg = require 'inicfg'
local encoding = require 'encoding'
encoding.default = 'CP1251'
u8 = encoding.UTF8

function apply_custom_style()
    imgui.SwitchContext()
    local style = imgui.GetStyle()
    local colors = style.Colors
    local clr = imgui.Col
    local ImVec4 = imgui.ImVec4

    style.WindowRounding = 2.0
    style.WindowTitleAlign = imgui.ImVec2(0.5, 0.84)
    style.ChildWindowRounding = 2.0
    style.FrameRounding = 2.0
    style.ItemSpacing = imgui.ImVec2(5.0, 4.0)
    style.ScrollbarSize = 13.0
    style.ScrollbarRounding = 0
    style.GrabMinSize = 8.0
    style.GrabRounding = 1.0

    colors[clr.FrameBg]                = ImVec4(0.16, 0.29, 0.48, 0.54)
    colors[clr.FrameBgHovered]         = ImVec4(0.26, 0.59, 0.98, 0.40)
    colors[clr.FrameBgActive]          = ImVec4(0.26, 0.59, 0.98, 0.67)
    colors[clr.TitleBg]                = ImVec4(0.04, 0.04, 0.04, 1.00)
    colors[clr.TitleBgActive]          = ImVec4(0.16, 0.29, 0.48, 1.00)
    colors[clr.TitleBgCollapsed]       = ImVec4(0.00, 0.00, 0.00, 0.51)
    colors[clr.CheckMark]              = ImVec4(0.26, 0.59, 0.98, 1.00)
    colors[clr.SliderGrab]             = ImVec4(0.24, 0.52, 0.88, 1.00)
    colors[clr.SliderGrabActive]       = ImVec4(0.26, 0.59, 0.98, 1.00)
    colors[clr.Button]                 = ImVec4(0.26, 0.59, 0.98, 0.40)
    colors[clr.ButtonHovered]          = ImVec4(0.26, 0.59, 0.98, 1.00)
    colors[clr.ButtonActive]           = ImVec4(0.06, 0.53, 0.98, 1.00)
    colors[clr.Header]                 = ImVec4(0.26, 0.59, 0.98, 0.31)
    colors[clr.HeaderHovered]          = ImVec4(0.26, 0.59, 0.98, 0.80)
    colors[clr.HeaderActive]           = ImVec4(0.26, 0.59, 0.98, 1.00)
    colors[clr.Separator]              = colors[clr.Border]
    colors[clr.SeparatorHovered]       = ImVec4(0.26, 0.59, 0.98, 0.78)
    colors[clr.SeparatorActive]        = ImVec4(0.26, 0.59, 0.98, 1.00)
    colors[clr.ResizeGrip]             = ImVec4(0.26, 0.59, 0.98, 0.25)
    colors[clr.ResizeGripHovered]      = ImVec4(0.26, 0.59, 0.98, 0.67)
    colors[clr.ResizeGripActive]       = ImVec4(0.26, 0.59, 0.98, 0.95)
    colors[clr.TextSelectedBg]         = ImVec4(0.26, 0.59, 0.98, 0.35)
    colors[clr.Text]                   = ImVec4(1.00, 1.00, 1.00, 1.00)
    colors[clr.TextDisabled]           = ImVec4(0.50, 0.50, 0.50, 1.00)
    colors[clr.WindowBg]               = ImVec4(0.06, 0.06, 0.06, 0.94)
    colors[clr.ChildWindowBg]          = ImVec4(1.00, 1.00, 1.00, 0.00)
    colors[clr.PopupBg]                = ImVec4(0.08, 0.08, 0.08, 0.94)
    colors[clr.ComboBg]                = colors[clr.PopupBg]
    colors[clr.Border]                 = ImVec4(0.43, 0.43, 0.50, 0.50)
    colors[clr.BorderShadow]           = ImVec4(0.00, 0.00, 0.00, 0.00)
    colors[clr.MenuBarBg]              = ImVec4(0.14, 0.14, 0.14, 1.00)
    colors[clr.ScrollbarBg]            = ImVec4(0.02, 0.02, 0.02, 0.53)
    colors[clr.ScrollbarGrab]          = ImVec4(0.31, 0.31, 0.31, 1.00)
    colors[clr.ScrollbarGrabHovered]   = ImVec4(0.41, 0.41, 0.41, 1.00)
    colors[clr.ScrollbarGrabActive]    = ImVec4(0.51, 0.51, 0.51, 1.00)
    colors[clr.CloseButton]            = ImVec4(0.41, 0.41, 0.41, 0.50)
    colors[clr.CloseButtonHovered]     = ImVec4(0.98, 0.39, 0.36, 1.00)
    colors[clr.CloseButtonActive]      = ImVec4(0.98, 0.39, 0.36, 1.00)
    colors[clr.PlotLines]              = ImVec4(0.61, 0.61, 0.61, 1.00)
    colors[clr.PlotLinesHovered]       = ImVec4(1.00, 0.43, 0.35, 1.00)
    colors[clr.PlotHistogram]          = ImVec4(0.90, 0.70, 0.00, 1.00)
    colors[clr.PlotHistogramHovered]   = ImVec4(1.00, 0.60, 0.00, 1.00)
    colors[clr.ModalWindowDarkening]   = ImVec4(0.80, 0.80, 0.80, 0.35)
end
apply_custom_style()

local config = {
	mfunc = {
		QuickDoors = false,
		SimplifiedDl = false,
        WheelFix = false,
        CutSpeedHack = false,
        AntiJamMotor = false,
        RepairCar = true,
        NitroMode = true,
        HydraulMode = false,
        ByeFuel = true,
        FireTroll = false,
        AntiFallOfBike = false,
        AntiEjectVehicle = false
	}
}

local status = inicfg.load(config, 'MyVehicleMenu.ini')
if not doesFileExist('moonloader/config/MyVehicleMenu.ini') then inicfg.save(config, 'MyVehicleMenu.ini') end

local window = imgui.ImBool(false)
local quick = imgui.ImBool(status.mfunc.QuickDoors)
local dl = imgui.ImBool(status.mfunc.SimplifiedDl)
local wf = imgui.ImBool(status.mfunc.WheelFix)
local sh = imgui.ImBool(status.mfunc.CutSpeedHack)
local antijm = imgui.ImBool(status.mfunc.AntiJamMotor)
local repair = imgui.ImBool(status.mfunc.RepairCar)
local nitro = imgui.ImBool(status.mfunc.NitroMode)
local hydr = imgui.ImBool(status.mfunc.HydraulMode)
local bfl = imgui.ImBool(status.mfunc.ByeFuel)
local ftrl = imgui.ImBool(status.mfunc.FireTroll)
local afb = imgui.ImBool(status.mfunc.AntiFallOfBike)
local aej = imgui.ImBool(status.mfunc.AntiEjectVehicle)

function main()
    troll = false
    local address = sampGetBase() + 0xD83A8
    while true do wait(0)
    if isKeyJustPressed(0x4D) and not sampIsChatInputActive() and not isSampfuncsConsoleActive() then 
    window.v = not window.v 
    imgui.Process = window.v 
    end
    if quick.v then 
        if isKeyJustPressed(0x4C) and not sampIsChatInputActive() and not sampIsDialogActive() and not isPauseMenuActive() and not isSampfuncsConsoleActive() then sampSendChat('/lock')
        end
    end
    if dl.v then
        local protect = memory.unprotect(address, 0x87) 
        ffi.copy(ffi.cast('void*', address), '[id: %d, type: %d subtype: %d Health: %.1f]', 0x87) 
        memory.protect(address, protect) 
    else
        local protect = memory.unprotect(address, 0x87) 
        ffi.copy(ffi.cast('void*', address), '[id: %d, type: %d subtype: %d Health: %.1f preloaded: %u]\nDistance: %.2fm\nPassengerSeats: %u\ncPos: %.3f,%.3f,%.3f\nsPos: %.3f,%.3f,%.3f', 0x87) 
        memory.protect(address, protect)
    end
    if wf.v then
        if isCharInAnyCar(PLAYER_PED) then
        local veh = storeCarCharIsInNoSave(PLAYER_PED)
            if isKeyJustPressed(0x58) then
                for tire = 0, 3 do
                fixCarTire(veh, tire)
                end
            end
        end
    end
    if sh.v then
        if isCharInAnyCar(PLAYER_PED) then
        local vehicle = storeCarCharIsInNoSave(PLAYER_PED)
        local speed = getCarSpeed(vehicle)
            if speed >=15 then
                if not isCarInAirProper(vehicle) then
           	        if not sampIsChatInputActive() and not sampIsDialogActive() then  
            			if isKeyDown(0x12) and speed then wait(300) setCarForwardSpeed(vehicle, speed + 9.6)
                        end
                    end
            	end
            end	  
        end
    end
    if antijm.v then
        if isCharInAnyCar(PLAYER_PED) then
            local veh = storeCarCharIsInNoSave(PLAYER_PED)
            if isCarVisiblyDamaged(veh) then
            setCarEngineBroken(veh, false)
            end
        end
    end
    if repair.v then
        if isCharInAnyCar(PLAYER_PED) then
            if isKeyJustPressed(0x50) then
            local veh = storeCarCharIsInNoSave(PLAYER_PED)
            setCarHealth(veh, 1000)
            fixCar(veh)
            end
        end
    end
    if nitro.v then
        if isCharInAnyCar(PLAYER_PED) then
            if isKeyJustPressed(0x4E) then
            local veh = storeCarCharIsInNoSave(PLAYER_PED)
            giveNonPlayerCarNitro(veh)
            end
        end
    end
    if hydr.v then
        if isCharInAnyCar(PLAYER_PED) then
        local veh = storeCarCharIsInNoSave(PLAYER_PED)
        setCarHydraulics(veh, true)
        end
    end
    if bfl.v then
        if isCharInAnyCar(PLAYER_PED) then
        local veh = storeCarCharIsInNoSave(PLAYER_PED)
        setCarEngineBroken(veh, false)
        end
    end
    if ftrl.v then
        if isKeyJustPressed(0x4F) then
        troll = not troll
        end
        if troll then
            if isCharInAnyCar(PLAYER_PED) then
                local veh = storeCarCharIsInNoSave(PLAYER_PED)
                local one, two = math.modf(localClock())
                if math.fmod(one, 2) == 0 and two < 0.1 then
                setCarHealth(veh, 1000.0)
                else
                setCarHealth(veh, 1.0)
                end
            end
        end
    end
    if afb.v then
        if isCharInAnyCar(PLAYER_PED) then
            setCharCanBeKnockedOffBike(PLAYER_PED, true)
        end
    end
    if isKeyJustPressed(0x2E) and isCharInAnyCar(PLAYER_PED) then
        local veh = storeCarCharIsInNoSave(PLAYER_PED)
        local oX, oY, oZ = getOffsetFromCarInWorldCoords(veh, 0.0,  0.0,  0.0)
        setCarCoordinates(veh, oX, oY, oZ)
    end
    if isKeyJustPressed(0x72) and isCharInAnyCar(PLAYER_PED) then
        local veh = storeCarCharIsInNoSave(PLAYER_PED)
        setCarHealth(veh, 200)
        end
    end
end

function sampev.onSetVehicleHealth(vehicleId, health)
    if antijm.v and repair.v then
        return false
    end
end

function sampev.onSendExitVehicle(vehicleId)
    if aej.v then
        return false
    end
end
 
function imgui.OnDrawFrame()
    imgui.ShowCursor = false 
    if window.v then
    imgui.ShowCursor = true
    imgui.SetNextWindowPos(imgui.ImVec2(sW / 2, sH / 2), imgui.Cond.FirstUseEver, imgui.ImVec2(0.5, 0.5))
    imgui.SetNextWindowSize(imgui.ImVec2(455, 150), imgui.Cond.FirstUseEver)
    imgui.Begin('MyVehicleMenu v0.1.1', window, imgui.WindowFlags.NoResize + imgui.WindowFlags.NoCollapse)
    imgui.Columns(3, 'nullptr', false)
    imgui.SetColumnWidth(-1, 150)
    imgui.Checkbox('QuickDoors', quick)
    imgui.SameLine(nil, 5)
	imgui.TextQuestion(u8'   /  . [   L,    ]')
    imgui.Checkbox('SimplifiedDl', dl)
    imgui.SameLine(nil, 5)
	imgui.TextQuestion(u8'  /dl   . : ServerID & GameID , HP . [     /DL]')
    imgui.Checkbox('WheelFix', wf) 
    imgui.SameLine(nil, 5)
    imgui.TextQuestion(u8'  ,    . [ X  ]')
    imgui.Checkbox('FireTroll', ftrl)
    imgui.SameLine(nil, 5)
	imgui.TextQuestion(u8'   , ,     . [  ,    O  ]')
    imgui.NextColumn()
    imgui.SetColumnWidth(-1, 150)
    imgui.Checkbox('CutSpeedHack', sh)
    imgui.SameLine(nil, 5)
	imgui.TextQuestion(u8'  ,        . [  ALT,   ;     ]')
    imgui.Checkbox('AntiJamMotor', antijm)
    imgui.SameLine(nil, 5)
	imgui.TextQuestion(u8'  ,     ,   ')
    imgui.Checkbox('RepairCar', repair)
    imgui.SameLine(nil, 5)
	imgui.TextQuestion(u8'   . [   P,   ]')
    imgui.Checkbox('AntiFallOfBike', afb)
    imgui.SameLine(nil, 5)
	imgui.TextQuestion(u8'     ')
    imgui.NextColumn()
    imgui.SetColumnWidth(-1, 150)
    imgui.Checkbox('NitroMode', nitro)
    imgui.SameLine(nil, 5)
	imgui.TextQuestion(u8'     [   N]')
    imgui.Checkbox('HydraulMode', hydr)
    imgui.SameLine(nil, 5)
	imgui.TextQuestion(u8'   ')
    imgui.Checkbox('ByeFuel', bfl)
    imgui.SameLine(nil, 5)
    imgui.TextQuestion(u8'      ')
    imgui.Checkbox('AntiEjectVehicle', aej)
    imgui.SameLine(nil, 5)
    imgui.TextQuestion(u8'       ')
    imgui.Columns(1)
    if imgui.Button(u8' ', imgui.ImVec2(-1, 0)) then
        status.mfunc.QuickDoors = quick.v
        status.mfunc.SimplifiedDl = dl.v
        status.mfunc.WheelFix = wf.v
        status.mfunc.CutSpeedHack = sh.v
        status.mfunc.AntiJamMotor = antijm.v
        status.mfunc.RepairCar = repair.v
        status.mfunc.NitroMode = nitro.v
        status.mfunc.HydraulMode = hydr.v
        status.mfunc.ByeFuel = bfl.v
        status.mfunc.FireTroll = ftrl.v
        status.mfunc.AntiFallOfBike = afb.v
        status.mfunc.AntiEjectVehicle = aej.v
        inicfg.save(config, 'MyVehicleMenu.ini')
        printStringNow('~g~Changes Saved Successfully', 1500)
    end
    imgui.End()   
    end
end

function imgui.TextQuestion(text)
    imgui.TextDisabled('(?)')
    if imgui.IsItemHovered() then
        imgui.BeginTooltip()
        imgui.PushTextWrapPos(450)
        imgui.TextUnformatted(text)
        imgui.PopTextWrapPos()
        imgui.EndTooltip()
    end
end